program GOLDENSEARCH;
{--------------------------------------------------------------------}
{  Alg8'1.pas   Pascal program for implementing Algorithm 8.1        }
{                                                                    }
{  NUMERICAL METHODS: Pascal Programs, (c) John H. Mathews 1995      }
{  To accompany the text:                                            }
{  NUMERICAL METHODS for Math., Science & Engineering, 2nd Ed, 1992  }
{  Prentice Hall, Englewood Cliffs, New Jersey, 07632, U.S.A.        }
{  Prentice Hall, Inc.; USA, Canada, Mexico ISBN 0-13-624990-6       }
{  Prentice Hall, International Editions:   ISBN 0-13-625047-5       }
{  This free software is compliments of the author.                  }
{  E-mail address:       in%"mathews@fullerton.edu"                  }
{                                                                    }
{  Algorithm 8.1 (Golden Search for a Minimum).                      }
{  Section   8.1, Minimization of a Function, Page 413               }
{--------------------------------------------------------------------}

  uses
    crt;

  type
    VECTOR = array[0..300] of real;
    LETTERS = string[200];
    STATUS = (Computing, Done, Working);

  var
    FunType, Inum, K, Sub: integer;
    A, A0, B, B0, Delta, Epsilon, P, Rnum: real;
    XA, XB, XC, XD: VECTOR;
    Ans: CHAR;
    Mess: LETTERS;
    Stat, State: STATUS;

  function F (X: real): real;
  begin
    case FunType of
      1: 
        F := X * X - SIN(X);
      2: 
        F := 3 * X * X - 2 * X + 5;
      3: 
        F := 2 * X * X * X - 3 * X * X - 12 * X + 1;
      4: 
        F := 4 * X * X * X - 8 * X * X - 11 * X + 5;
      5: 
        F := X + 3 / (X * X);
      6: 
        F := (X + 2.5) / (4 - X * X);
      7: 
        F := EXP(X) / (X * X);
      8: 
        F := -SIN(X) - SIN(3 * X) / 3;
      9: 
        F := -2 * SIN(X) + SIN(2 * X) - 2 * SIN(3 * X) / 3;
    end;
  end;

  procedure PRINTFUN (FunType: integer);
  begin
    case FunType of
      1: 
        WRITELN('X*X - SIN(X)');
      2: 
        WRITELN('3*X*X - 2*X + 5');
      3:
        WRITELN('2*X*X*X - 3*X*X - 12*X + 1');
      4: 
        WRITELN('4*X*X*X - 8*X*X - 11*X + 5');
      5: 
        WRITELN('X + 3/(X*X)');
      6: 
        WRITELN('(X + 2.5)/(4 - X*X)');
      7: 
        WRITELN('EXP(X)/(X*X)');
      8: 
        WRITELN('- SIN(X) - SIN(3*X)/3');
      9: 
        WRITELN('- 2*SIN(X) + SIN(2*X) - 2*SIN(3*X)/3');
    end;
  end;

  procedure SEARCH ( {FUNCTION F(X:real): real}
                  var A, B, P: real; var K: integer; Delta, Epsilon: real);
    var
      C, D, H, Rone, Rtwo, YP, YA, YB, YC, YD: real;
  begin
    XA[0] := A; {Extra information.}
    XB[0] := B;
    Rone := (SQRT(5) - 1) / 2;
    Rtwo := Rone * Rone;
    H := B - A;
    YA := F(A);
    YB := F(B);
    C := A + Rtwo * H;
    D := A + Rone * H;
    XC[0] := C; {Extra information.}
    XD[0] := D;
    YC := F(C);
    YD := F(D);
    K := 1;
    while (ABS(YB - YA) > Epsilon) or (H > Delta) do
      begin
        if YC < YD then
          begin
            B := D;                               {Squeeze from the right}
            YB := YD;
            D := C;
            YD := YC;
            H := B - A;
            C := A + Rtwo * H;
            YC := F(C);
          end
        else
          begin
            A := C;                                {Squeeze from the left}
            YA := YC;
            C := D;
            YC := YD;
            H := B - A;
            D := A + Rone * H;
            YD := F(D);
          end;
        XA[K] := A;  {Extra information.}
        XB[K] := B;
        XC[K] := C;  {Extra information.}
        XD[K] := D;
        K := K + 1;
      end;
    P := A;
    YP := YA;
    if YB < YA then
      begin
        P := B;
        YP := YB;
      end;
  end;                                        {End of Procedure SEARCH}

  procedure GETFUN (var FunType: integer);
    var
      K: integer;
  begin
    CLRSCR;
    WRITELN;
    WRITELN('     You have a choice of functions:');
    WRITELN;
    for K := 1 to 9 do
      begin
        WRITE('     <', K : 2, ' >  F(X) = ');
        PRINTFUN(K);
        WRITELN;
      end;
    Mess := '     Select < 1 - 9 > ?  ';
    FunType := 1;
    WRITE(Mess);
    READLN(FunType);
    if FunType < 1 then
      FunType := 1;
    if FunType > 9 then
      FunType := 9;
  end;

  procedure INPUT (var A0, B0, A, B, Delta, Epsilon: real);
    var
      T: real;
  begin
    CLRSCR;
    WRITELN;
    WRITELN;
    WRITELN('     You chose to find an approximation for the minimum of:');
    WRITELN;
    WRITE('         F(X)  =  ');
    PRINTFUN(FunType);
    WRITELN;
    WRITELN('over an interval [A,B].  Sequences { a  } and { b  } are constructed,');
    WRITELN('                                      k          k');
    WRITELN;
    WRITELN('which bracket the minimum, i.e.  a  < x   < b .  Termination occurs');
    WRITELN('                                  k    Min   k  ');
    WRITELN;
    WRITELN('when   b - a  < Delta   OR   |F(a ) - F(b )| < Epsilon.');
    WRITELN('        N   N                    N       N         ');
    WRITELN;
    WRITELN('Now you must select A , B , Delta and Epsilon.');
    WRITELN;
    WRITELN;
    Mess := '     ENTER  the  left   endpoint  A = ';
    A := 0;
    WRITE(Mess);
    READLN(A);
    A0 := A;
    WRITELN;
    Mess := '     ENTER  the  right  endpoint  B = ';
    B := 1;
    WRITE(Mess);
    READLN(B);
    B0 := B;
    WRITELN;
    Mess := '     ENTER  the  value  for   Delta = ';
    Delta := 1E-7;
    WRITE(Mess);
    READLN(Delta);
    Delta := ABS(Delta);
    if Delta < 1E-7 then
      Delta := 1E-7;
    WRITELN;
    Mess := '     ENTER  the  value  for Epsilon = ';
    Epsilon := 1E-7;
    WRITE(Mess);
    READLN(Epsilon);
    Epsilon := ABS(Epsilon);
    if Epsilon < 1E-7 then
      Epsilon := 1E-7;
    WRITELN;
    if B < A then
      begin
        T := A;
        A := B;
        B := T;
        A0 := A;
        B0 := B;
      end;
  end;

  procedure ANSWER (A0, B0, A, B, P, Delta, Epsilon: real; K: integer);
    var
      H: real;
  begin
    CLRSCR;
    WRITELN;
    WRITELN('     The "golden search" was used to find an approximation for');
    WRITELN;
    WRITELN('the minimum of the function  f(x)  over the interval  [A,B].');
    WRITELN;
    WRITELN('     It took ', K : 2, ' iterations to minimize');
    WRITELN;
    WRITE('          F(X)  =  ');
    PRINTFUN(FunType);
    WRITELN;
    WRITELN('over the interval  [', A0 : 15 : 7, ',', B0 : 15 : 7, '  ].');
    WRITELN;
    WRITELN('The  minimum  value f(p)');
    WRITELN;
    WRITELN('          occurs  at  p  = ', P : 15 : 7);
    WRITELN;
    H := B - A;
    WRITELN('    The  accuracy  is    +-', H : 15 : 7);
    WRITELN;
    WRITELN('The function value is:');
    WRITELN;
    WRITELN('   f(', P : 15 : 7, '  )  = ', F(P) : 15 : 7);
  end;

  procedure MESSAGE;
  begin
    CLRSCR;
    WRITELN;
    WRITELN('                     SEARCH FOR A MINIMUM');
    WRITELN;
    WRITELN;
    WRITELN('         The "golden search" is used for finding the minimum');
    WRITELN;
    WRITELN;
    WRITELN('     of the unimodal function  f(x)  over the interval  [A,B].');
    WRITELN;
    WRITELN;
    WRITELN('     Sequences {a } and {b } are constructed, which bracket the');
    WRITELN('                 k        k');
    WRITELN;
    WRITELN('     minimum, i.e.  a  < X   < b .   Termination occurs when');
    WRITELN('                     k    Min   k ');
    WRITELN;
    WRITELN('            b - a  < Delta    OR    |f(a ) - f(b )| < Epsilon.');
    WRITELN('             N   N                      N       N         ');
    WRITELN;
    WRITELN;
    WRITELN;
    WRITE('                     Press the <ENTER> key.  ');
    READ(Ans);
  end;

  procedure PRINTAPPROXS;
    var
      J: integer;
  begin
    CLRSCR;
    WRITELN;
    WRITELN('        a                 b                  c                 d  ');
    WRITELN('         k                 k                  k                 k ');
    WRITELN('------------------------------------------------------------------------------');
    WRITELN;
    for J := 0 to K - 1 do
      begin
        WRITELN(XA[J] : 15 : 7, '   ', XC[J] : 15 : 7, '    ', XD[J] : 15 : 7, '   ', XB[J] : 15 : 7);
        WRITELN;
        if J mod 11 = 9 then
          begin
            WRITE('                  Press the <ENTER> key.  ');
            READLN(Ans);
            WRITELN;
            WRITELN;
            WRITELN;
          end;
      end;
    WRITELN;
    WRITE('                  Press the <ENTER> key.  ');
    READLN(Ans);
    WRITELN;
    WRITELN;
  end;

begin                                            {Begin Main Program}
  MESSAGE;
  Stat := Working;
  while (Stat = Working) do
    begin
      GETFUN(FunType);
      State := Computing;
      while (State = Computing) do
        begin
          INPUT(A0, B0, A, B, Delta, Epsilon);
          SEARCH(A, B, P, K, Delta, Epsilon);
          ANSWER(A0, B0, A, B, P, Delta, Epsilon, K);
          WRITELN;
          WRITE('Want  to see  all  of the approximations ?  <Y/N>  ');
          READLN(Ans);
          WRITELN;
          if (Ans = 'Y') or (Ans = 'y') then
            PRINTAPPROXS;
          WRITELN;
          WRITE('Want to try a different  search interval ?  <Y/N>  ');
          READLN(Ans);
          WRITELN;
          if (Ans <> 'Y') and (Ans <> 'y') then
            State := Done;
          if (Ans = 'Y') or (Ans = 'y') then
            CLRSCR;
        end;
      WRITELN;
      WRITE('Want  to try  a different function  F(X) ?  <Y/N>  ');
      READLN(Ans);
      WRITELN;
      if (Ans <> 'Y') and (Ans <> 'y') then
        Stat := Done
    end;
end.                                               {End Main Program}

